﻿#include "precompiled.h"
#include "common.h"
#include "PixelShader.h"

using namespace DirectX;

namespace RTCam {

PixelShader::PixelShader(void) :
	m_pixelShader(nullptr)
{
}

PixelShader::~PixelShader(void)
{
}

ComPtr<ID3DBlob> PixelShader::Load(_In_z_ const char* filename, _In_ ID3D11Device1* d3dDevice)
{
	ComPtr<ID3DBlob> shaderBlob = LoadShader(filename, "main", "ps_5_0");
	ThrowIfFailed(
		d3dDevice->CreatePixelShader(
		shaderBlob->GetBufferPointer(),
		shaderBlob->GetBufferSize(),
		nullptr,
		&m_pixelShader
		)
		);

	SetDebugObjectName(m_pixelShader.Get(), filename);

	return shaderBlob;
}


} // end namespace